// =========================
// Paste your 400 MCQs here
// Format: { q: "Question", options: ["A","B","C","D"], answer: 0 }
// =========================
const questions = [
/* ===== UNIT 1 ===== */
{
  q: "Rural studies mainly deals with?",
  options: [
    "Urban society",
    "Industrial development",
    "Rural society",
    "Corporate economy"
  ],
  answer: 2
},
{
  q: "Rural society is primarily based on?",
  options: [
    "Agriculture",
    "Industry",
    "IT services",
    "Trade"
  ],
  answer: 0
},

/* ===== UNIT 2 ===== */
{
  q: "Jajmani system is related to?",
  options: [
    "Political system",
    "Economic exchange",
    "Religious practice",
    "Education system"
  ],
  answer: 1
},
{
  q: "Dominant caste concept was given by?",
  options: [
    "M. N. Srinivas",
    "Karl Marx",
    "Max Weber",
    "Durkheim"
  ],
  answer: 0
},

/* ===== UNIT 3 ===== */
{
  q: "73rd Constitutional Amendment was passed in?",
  options: [
    "1985",
    "1990",
    "1992",
    "2000"
  ],
  answer: 2
},

/* ===== UNIT 4 ===== */
{
  q: "MGNREGS guarantees employment for?",
  options: [
    "50 days",
    "75 days",
    "100 days",
    "150 days"
  ],
  answer: 2
},

/* ===== UNIT 5 ===== */
{
  q: "NABARD stands for?",
  options: [
    "National Bank for Rural Development",
    "National Agriculture Bank",
    "National Bank for Agriculture and Rural Development",
    "Rural Agriculture Bank"
  ],
  answer: 2
},

/* 🔴 CONTINUE ADDING ALL 400 QUESTIONS
   SAME FORMAT — YOU ALREADY HAVE THEM
*/
/* =======================
   UNIT–1: RURAL STUDIES
   ======================= */

{
  q: "Rural studies mainly deals with the study of?",
  options: ["Urban society", "Industrial society", "Rural society", "Corporate society"],
  answer: 2
},
{
  q: "Rural society is primarily based on?",
  options: ["Trade", "Industry", "Agriculture", "IT services"],
  answer: 2
},
{
  q: "The term 'rural' generally refers to?",
  options: ["Cities", "Villages", "Metropolitan areas", "Industrial towns"],
  answer: 1
},
{
  q: "Rural studies is an interdisciplinary subject because it involves?",
  options: ["Only sociology", "Only economics", "Multiple social sciences", "Only history"],
  answer: 2
},
{
  q: "Which of the following is a key feature of rural society?",
  options: ["High population density", "Strong community life", "Industrial dominance", "Advanced technology"],
  answer: 1
},
{
  q: "Rural studies helps in understanding?",
  options: ["Urban planning", "Village life", "Corporate culture", "International trade"],
  answer: 1
},
{
  q: "Rural society is generally characterized by?",
  options: ["Joint family system", "Nuclear family system", "Individualism", "Urban lifestyle"],
  answer: 0
},
{
  q: "The scope of rural studies includes?",
  options: ["Only economy", "Only culture", "Social, economic and political aspects", "Only agriculture"],
  answer: 2
},
{
  q: "Rural studies mainly focuses on?",
  options: ["City development", "Village development", "Industrial growth", "Corporate profit"],
  answer: 1
},
{
  q: "Which occupation is dominant in rural areas?",
  options: ["IT services", "Banking", "Agriculture", "Manufacturing"],
  answer: 2
},

{
  q: "Rural society generally shows which type of relationship?",
  options: ["Secondary", "Formal", "Primary", "Contractual"],
  answer: 2
},
{
  q: "Rural studies helps policy makers in?",
  options: ["Urban planning", "Rural development planning", "Corporate expansion", "Military strategy"],
  answer: 1
},
{
  q: "Rural population mainly depends on?",
  options: ["Industry", "Trade", "Agriculture", "Services"],
  answer: 2
},
{
  q: "Which is an important institution of rural society?",
  options: ["Stock exchange", "Parliament", "Family", "Corporation"],
  answer: 2
},
{
  q: "Rural studies gained importance mainly due to?",
  options: ["Urbanization", "Rural poverty", "Industrialization", "Globalization"],
  answer: 1
},
{
  q: "Village community is generally?",
  options: ["Self-sufficient", "Fully dependent on cities", "Industrial", "Commercial"],
  answer: 0
},
{
  q: "Rural studies helps in understanding rural?",
  options: ["Politics only", "Economy only", "Social structure", "Technology only"],
  answer: 2
},
{
  q: "Which of the following best defines rural studies?",
  options: [
    "Study of cities",
    "Study of industries",
    "Study of rural life and institutions",
    "Study of markets"
  ],
  answer: 2
},
{
  q: "Rural society is generally less affected by?",
  options: ["Tradition", "Customs", "Modernization", "Community life"],
  answer: 2
},
{
  q: "Rural studies examines rural problems like?",
  options: ["Urban crime", "Traffic congestion", "Poverty and unemployment", "Cyber crime"],
  answer: 2
},

{
  q: "Rural life is closely associated with?",
  options: ["Nature", "Technology", "Industry", "Markets"],
  answer: 0
},
{
  q: "The importance of rural studies lies in?",
  options: ["Urban growth", "Understanding rural realities", "Corporate profit", "Industrial expansion"],
  answer: 1
},
{
  q: "Rural studies helps in bridging gap between?",
  options: ["Rich and rich", "Urban and rural areas", "Industry and IT", "Government and corporates"],
  answer: 1
},
{
  q: "Rural society generally follows?",
  options: ["Written laws only", "Customary norms", "Corporate rules", "Market laws"],
  answer: 1
},
{
  q: "Rural studies contributes to?",
  options: ["Military planning", "Rural development policies", "Corporate strategy", "Urban design"],
  answer: 1
},
{
  q: "Rural communities usually have?",
  options: ["High mobility", "Low mobility", "Frequent migration", "No settlement"],
  answer: 1
},
{
  q: "Rural social structure is mostly?",
  options: ["Complex", "Simple", "Highly industrial", "Technological"],
  answer: 1
},
{
  q: "Which value is strong in rural society?",
  options: ["Competition", "Individualism", "Cooperation", "Consumerism"],
  answer: 2
},
{
  q: "Rural studies is important for understanding?",
  options: ["Rural change", "Urban traffic", "Corporate finance", "Stock market"],
  answer: 0
},
{
  q: "Rural areas are generally characterized by?",
  options: ["High cost of living", "Low population density", "Advanced infrastructure", "Urban lifestyle"],
  answer: 1
},

{
  q: "Rural studies also examines?",
  options: ["Village traditions", "Urban crime", "Corporate law", "International relations"],
  answer: 0
},
{
  q: "Rural studies is useful for?",
  options: ["Students and planners", "Only farmers", "Only politicians", "Only corporates"],
  answer: 0
},
{
  q: "Rural society is closely linked with?",
  options: ["Agriculture and land", "Industry and capital", "Technology and innovation", "Trade and commerce"],
  answer: 0
},
{
  q: "Rural studies helps in understanding rural?",
  options: ["Power structure", "Stock exchange", "Corporate hierarchy", "Urban planning"],
  answer: 0
},
{
  q: "Which of the following is a rural institution?",
  options: ["Municipal corporation", "Village panchayat", "High court", "Parliament"],
  answer: 1
},
{
  q: "Rural studies focuses on improving?",
  options: ["Urban luxury", "Rural quality of life", "Corporate profit", "Industrial output"],
  answer: 1
},
{
  q: "Rural society mostly depends on?",
  options: ["Land and agriculture", "Industry", "IT sector", "Banking"],
  answer: 0
},
{
  q: "Rural studies highlights the importance of?",
  options: ["Local participation", "Centralization", "Corporate dominance", "Urban control"],
  answer: 0
},
{
  q: "Rural studies helps in addressing rural?",
  options: ["Problems", "Luxury", "Corporate issues", "Urban planning"],
  answer: 0
},
{
  q: "Rural life is generally governed by?",
  options: ["Formal rules", "Customs and traditions", "Corporate policies", "Written contracts"],
  answer: 1
},

{
  q: "Rural studies also examines rural?",
  options: ["Economy", "Culture", "Politics", "All of the above"],
  answer: 3
},
{
  q: "Rural society emphasizes?",
  options: ["Materialism", "Community values", "Consumerism", "Competition"],
  answer: 1
},
{
  q: "Rural studies is essential for?",
  options: ["Balanced development", "Urban dominance", "Corporate monopoly", "Central rule"],
  answer: 0
},
{
  q: "Rural studies aims at understanding rural?",
  options: ["Structure and change", "Corporate profit", "Urban growth", "Industrial policy"],
  answer: 0
},
{
  q: "Rural studies helps in formulation of?",
  options: ["Defence policy", "Rural development programmes", "Trade policy", "Foreign policy"],
  answer: 1
},
{
  q: "Rural areas usually have?",
  options: ["Advanced transport", "Limited infrastructure", "High-tech facilities", "Skyscrapers"],
  answer: 1
},
{
  q: "Rural society generally shows?",
  options: ["Close social ties", "Formal relations", "Impersonal relations", "Contractual relations"],
  answer: 0
},
{
  q: "Rural studies helps to reduce?",
  options: ["Understanding", "Inequality", "Education", "Development"],
  answer: 1
},
{
  q: "Rural studies contributes to?",
  options: ["Social development", "Corporate expansion", "Urban luxury", "Military power"],
  answer: 0
},
{
  q: "Rural studies ultimately aims at?",
  options: ["Human development", "Corporate growth", "Urban dominance", "Centralization"],
  answer: 0
},

{
  q: "Rural society refers to a society mainly based on?",
  options: ["Industry", "Agriculture", "Trade", "IT services"],
  answer: 1
},
{
  q: "Rural society is characterized by?",
  options: ["High mobility", "Close social relations", "Urban lifestyle", "Individualism"],
  answer: 1
},
{
  q: "Self-sufficient village community means?",
  options: ["Dependent on cities", "Independent in basic needs", "Industrialized", "Commercialized"],
  answer: 1
},
{
  q: "Traditional rural villages were mostly?",
  options: ["Industrial units", "Self-reliant", "Urban dependent", "Corporate based"],
  answer: 1
},
{
  q: "Rural economy mainly depends on?",
  options: ["Industry", "Agriculture", "Trade", "Services"],
  answer: 1
},

{
  q: "Jajmani system is related to?",
  options: ["Political system", "Economic exchange system", "Religious system", "Educational system"],
  answer: 1
},
{
  q: "Jajmani system is based on?",
  options: ["Cash payment", "Barter and service exchange", "Industrial wages", "Corporate salary"],
  answer: 1
},
{
  q: "Jajmani system ensured?",
  options: ["Urban growth", "Economic interdependence", "Industrial profit", "Capital accumulation"],
  answer: 1
},
{
  q: "Jajmani system mainly existed in?",
  options: ["Urban areas", "Rural areas", "Industrial towns", "Metropolitan cities"],
  answer: 1
},
{
  q: "Jajmani system declined due to?",
  options: ["Modernization", "Urbanization", "Market economy", "All of the above"],
  answer: 3
},

{
  q: "Rural family is generally?",
  options: ["Nuclear", "Joint", "Individual", "Isolated"],
  answer: 1
},
{
  q: "Joint family system is common in?",
  options: ["Urban society", "Rural society", "Industrial society", "Corporate sector"],
  answer: 1
},
{
  q: "Rural family performs which function?",
  options: ["Economic", "Socialization", "Protection", "All of the above"],
  answer: 3
},
{
  q: "Rural family is an important unit of?",
  options: ["Urban culture", "Social structure", "Corporate structure", "Political party"],
  answer: 1
},
{
  q: "Authority in rural family usually lies with?",
  options: ["Youngest member", "Women only", "Eldest male member", "Children"],
  answer: 2
},

{
  q: "Caste system is an important feature of?",
  options: ["Urban society", "Rural society", "Industrial society", "Corporate society"],
  answer: 1
},
{
  q: "Dominant caste concept was given by?",
  options: ["M. N. Srinivas", "Karl Marx", "Max Weber", "Durkheim"],
  answer: 0
},
{
  q: "Dominant caste enjoys dominance due to?",
  options: ["Numerical strength", "Economic power", "Political power", "All of the above"],
  answer: 3
},
{
  q: "Dominant caste is influential in?",
  options: ["Village politics", "Social relations", "Economic activities", "All of the above"],
  answer: 3
},
{
  q: "Dominant caste concept applies mainly to?",
  options: ["Urban areas", "Villages", "Industries", "Corporates"],
  answer: 1
},

{
  q: "Peasant society refers to a society based on?",
  options: ["Industry", "Agriculture", "Trade", "IT services"],
  answer: 1
},
{
  q: "Peasants are mainly engaged in?",
  options: ["Manufacturing", "Farming", "Trade", "Services"],
  answer: 1
},
{
  q: "Peasant society is characterized by?",
  options: ["Subsistence farming", "Capital intensive farming", "Industrial production", "Urban economy"],
  answer: 0
},
{
  q: "Peasant society is closely linked with?",
  options: ["Land", "Industry", "Technology", "Markets"],
  answer: 0
},
{
  q: "Peasant society is mostly found in?",
  options: ["Urban areas", "Rural areas", "Industrial towns", "Metros"],
  answer: 1
},

{
  q: "Agrarian class structure refers to?",
  options: ["Urban classes", "Land-based class divisions", "Industrial classes", "Corporate hierarchy"],
  answer: 1
},
{
  q: "Daniel Thorner classified agrarian classes based on?",
  options: ["Caste", "Land ownership", "Education", "Income"],
  answer: 1
},
{
  q: "Daniel Thorner classified peasants into?",
  options: ["Two groups", "Three groups", "Four groups", "Five groups"],
  answer: 1
},
{
  q: "Daniel Thorner’s agrarian classes include?",
  options: ["Maliks, Kisans, Mazdoors", "Capitalists, workers, peasants", "Landlords, traders, labourers", "Farmers only"],
  answer: 0
},
{
  q: "Maliks are?",
  options: ["Landless labourers", "Large landowners", "Tenants", "Artisans"],
  answer: 1
},

{
  q: "Kisans are?",
  options: ["Landless labourers", "Small and medium farmers", "Urban workers", "Industrial workers"],
  answer: 1
},
{
  q: "Mazdoors are?",
  options: ["Landowners", "Tenants", "Landless labourers", "Traders"],
  answer: 2
},
{
  q: "D. N. Dhanagare focused on?",
  options: ["Urban classes", "Agrarian class relations", "Industrial relations", "Corporate hierarchy"],
  answer: 1
},
{
  q: "Dhanagare emphasized?",
  options: ["Class conflict", "Land relations", "Power structure", "All of the above"],
  answer: 3
},
{
  q: "Agrarian class structure reflects?",
  options: ["Land ownership inequality", "Urban inequality", "Corporate inequality", "Educational inequality"],
  answer: 0
},

{
  q: "Rural economy is influenced by?",
  options: ["Land ownership", "Caste system", "Agricultural production", "All of the above"],
  answer: 3
},
{
  q: "Traditional rural economy was mostly?",
  options: ["Market oriented", "Subsistence oriented", "Industrial", "Export oriented"],
  answer: 1
},
{
  q: "Modernization led to changes in?",
  options: ["Jajmani system", "Family structure", "Caste relations", "All of the above"],
  answer: 3
},
{
  q: "Rural institutions include?",
  options: ["Family and caste", "Stock exchange", "Corporations", "Parliament"],
  answer: 0
},
{
  q: "Rural social structure is mostly?",
  options: ["Flexible", "Rigid", "Corporate", "Urban"],
  answer: 1
},

{
  q: "Land plays a central role in?",
  options: ["Urban economy", "Rural economy", "IT sector", "Corporate finance"],
  answer: 1
},
{
  q: "Agrarian relations are relations between?",
  options: ["Urban groups", "Landowners and labourers", "Corporates", "Industries"],
  answer: 1
},
{
  q: "Peasant movements are related to?",
  options: ["Urban workers", "Agrarian issues", "Corporate profits", "Industrial disputes"],
  answer: 1
},
{
  q: "Rural stratification is based on?",
  options: ["Caste and land", "Education only", "Income only", "Technology"],
  answer: 0
},
{
  q: "Rural socio-economic structure shows?",
  options: ["Homogeneity", "Inequality", "Corporate equality", "Urban equality"],
  answer: 1
},

{
  q: "Rural economy is slowly shifting towards?",
  options: ["Pure subsistence", "Market orientation", "Industrial monopoly", "Corporate control"],
  answer: 1
},
{
  q: "Decline of jajmani system led to?",
  options: ["Economic dependency", "Freedom of occupation", "Urban dominance", "Caste rigidity"],
  answer: 1
},
{
  q: "Rural society is changing due to?",
  options: ["Education", "Technology", "Government policies", "All of the above"],
  answer: 3
},
{
  q: "Agrarian class conflict arises due to?",
  options: ["Land inequality", "Urbanization", "Education", "Technology"],
  answer: 0
},
{
  q: "Rural socio-economic structure determines?",
  options: ["Power relations", "Production relations", "Social hierarchy", "All of the above"],
  answer: 3
},

{
  q: "Peasant society is vulnerable to?",
  options: ["Natural disasters", "Market fluctuations", "Debt", "All of the above"],
  answer: 3
},
{
  q: "Land reforms aimed to reduce?",
  options: ["Urban poverty", "Land inequality", "Industrial conflict", "Corporate monopoly"],
  answer: 1
},
{
  q: "Agrarian structure influences?",
  options: ["Village politics", "Social relations", "Economic life", "All of the above"],
  answer: 3
},
{
  q: "Rural institutions help in maintaining?",
  options: ["Social order", "Corporate order", "Urban law", "Industrial discipline"],
  answer: 0
},
{
  q: "Rural socio-economic structure is best understood through?",
  options: ["Caste, class and land relations", "Technology only", "Urban models", "Corporate models"],
  answer: 0
},

{
  q: "Rural power structure refers to?",
  options: ["Economic system", "Distribution of power in villages", "Urban administration", "Industrial control"],
  answer: 1
},
{
  q: "Traditional rural power was mainly based on?",
  options: ["Education", "Caste and land", "Technology", "Industry"],
  answer: 1
},
{
  q: "Caste council is known as?",
  options: ["Gram Sabha", "Caste Panchayat", "Zila Parishad", "Lok Sabha"],
  answer: 1
},
{
  q: "Caste Panchayat mainly regulates?",
  options: ["Urban laws", "Caste norms and customs", "Industrial disputes", "National politics"],
  answer: 1
},
{
  q: "Traditional caste council exercised power through?",
  options: ["Legal force", "Social sanctions", "Police authority", "Military power"],
  answer: 1
},

{
  q: "Village Panchayat in traditional society was?",
  options: ["Elected body", "Hereditary body", "Government office", "Urban institution"],
  answer: 1
},
{
  q: "Traditional village panchayat decisions were based on?",
  options: ["Written laws", "Customs and traditions", "Constitution", "Court orders"],
  answer: 1
},
{
  q: "Traditional power structure was mostly?",
  options: ["Democratic", "Centralized", "Informal", "Judicial"],
  answer: 2
},
{
  q: "Traditional rural leadership was exercised by?",
  options: ["Educated youth", "Upper castes", "Government officials", "Industrialists"],
  answer: 1
},
{
  q: "Landowners played an important role in?",
  options: ["Urban governance", "Rural power structure", "Industrial policy", "National politics"],
  answer: 1
},

{
  q: "Modern rural power structure emerged with?",
  options: ["British rule", "Urbanization", "Panchayati Raj Institutions", "Industrialization"],
  answer: 2
},
{
  q: "Local Self-Government means?",
  options: ["Rule by central government", "Self-rule at local level", "Corporate governance", "Urban administration"],
  answer: 1
},
{
  q: "Panchayati Raj Institutions aim to promote?",
  options: ["Centralization", "Decentralization", "Industrial growth", "Urban development"],
  answer: 1
},
{
  q: "PRIs are part of?",
  options: ["Judiciary", "Executive", "Local governance", "Private sector"],
  answer: 2
},
{
  q: "The Panchayati Raj system operates at?",
  options: ["One level", "Two levels", "Three levels", "Four levels"],
  answer: 2
},

{
  q: "Three-tier Panchayati Raj system includes?",
  options: ["Gram Sabha, Lok Sabha, Rajya Sabha", "Gram Panchayat, Panchayat Samiti, Zila Parishad", "Municipality, Corporation, Council", "Village council only"],
  answer: 1
},
{
  q: "The lowest tier of Panchayati Raj is?",
  options: ["Zila Parishad", "Panchayat Samiti", "Gram Panchayat", "Municipality"],
  answer: 2
},
{
  q: "The intermediate level of PRIs is?",
  options: ["Gram Panchayat", "Zila Parishad", "Panchayat Samiti", "Gram Sabha"],
  answer: 2
},
{
  q: "The apex body of PRIs at district level is?",
  options: ["Gram Sabha", "Gram Panchayat", "Panchayat Samiti", "Zila Parishad"],
  answer: 3
},
{
  q: "Gram Sabha consists of?",
  options: ["Elected members only", "All adult village members", "Government officials", "Political leaders"],
  answer: 1
},

{
  q: "Gram Sabha is regarded as?",
  options: ["Judicial body", "Foundation of PRIs", "Urban institution", "Private organization"],
  answer: 1
},
{
  q: "Main function of Gram Panchayat is?",
  options: ["Policy making", "Local administration and development", "National defense", "Industrial planning"],
  answer: 1
},
{
  q: "Panchayat Samiti works at?",
  options: ["Village level", "Block level", "District level", "State level"],
  answer: 1
},
{
  q: "Zila Parishad functions at?",
  options: ["Village level", "Block level", "District level", "State level"],
  answer: 2
},
{
  q: "PRIs strengthen?",
  options: ["Urban governance", "Grassroots democracy", "Corporate control", "Central authority"],
  answer: 1
},

{
  q: "73rd Constitutional Amendment Act was enacted in?",
  options: ["1985", "1990", "1992", "2000"],
  answer: 2
},
{
  q: "73rd Amendment gave constitutional status to?",
  options: ["Municipalities", "PRIs", "Corporations", "NGOs"],
  answer: 1
},
{
  q: "73rd Amendment applies to?",
  options: ["Urban areas", "Rural areas", "Industrial areas", "Metropolitan cities"],
  answer: 1
},
{
  q: "Reservation in PRIs is provided for?",
  options: ["Women", "SCs and STs", "OBCs", "All of the above"],
  answer: 3
},
{
  q: "Minimum reservation for women in PRIs is?",
  options: ["25%", "30%", "33%", "50%"],
  answer: 2
},

{
  q: "Tenure of Panchayati Raj institutions is?",
  options: ["3 years", "4 years", "5 years", "6 years"],
  answer: 2
},
{
  q: "State Election Commission conducts elections for?",
  options: ["Lok Sabha", "Rajya Sabha", "PRIs", "Municipal Corporations only"],
  answer: 2
},
{
  q: "State Finance Commission deals with?",
  options: ["Urban finance", "Allocation of resources to PRIs", "Industrial taxation", "Corporate finance"],
  answer: 1
},
{
  q: "One major objective of PRIs is?",
  options: ["Central control", "Local participation", "Industrial profit", "Urban expansion"],
  answer: 1
},
{
  q: "PRIs promote political awareness among?",
  options: ["Urban elites", "Rural masses", "Industrial workers", "Corporate employees"],
  answer: 1
},

{
  q: "Modern rural power structure is more?",
  options: ["Hereditary", "Democratic", "Rigid", "Caste-based"],
  answer: 1
},
{
  q: "Elected representatives exercise power through?",
  options: ["Customs", "Legal authority", "Social boycott", "Religious sanctions"],
  answer: 1
},
{
  q: "Decentralization means?",
  options: ["Transfer of power to center", "Transfer of power to local bodies", "Corporate control", "Urban dominance"],
  answer: 1
},
{
  q: "PRIs act as instruments of?",
  options: ["Rural development", "Urban planning", "Industrial growth", "Corporate expansion"],
  answer: 0
},
{
  q: "Traditional power structure was replaced gradually by?",
  options: ["Military rule", "Democratic institutions", "Corporate governance", "Judicial system"],
  answer: 1
},

{
  q: "Rural power is now influenced by?",
  options: ["Caste only", "Land only", "Education and politics", "Religion only"],
  answer: 2
},
{
  q: "Political parties influence rural power through?",
  options: ["PRIs", "Caste councils", "Family system", "Jajmani system"],
  answer: 0
},
{
  q: "Leadership in villages today is often based on?",
  options: ["Birth", "Merit and election", "Caste only", "Age only"],
  answer: 1
},
{
  q: "PRIs ensure participation of marginalized groups through?",
  options: ["Social boycott", "Reservation", "Hereditary rule", "Customs"],
  answer: 1
},
{
  q: "Rural power structure affects?",
  options: ["Development planning", "Resource distribution", "Social justice", "All of the above"],
  answer: 3
},

{
  q: "Traditional caste councils lacked?",
  options: ["Authority", "Legal recognition", "Social control", "Influence"],
  answer: 1
},
{
  q: "Modern PRIs function under?",
  options: ["Customary laws", "Constitutional provisions", "Religious texts", "Caste rules"],
  answer: 1
},
{
  q: "Rural governance today is more?",
  options: ["Inclusive", "Exclusive", "Hereditary", "Rigid"],
  answer: 0
},
{
  q: "PRIs help in conflict resolution through?",
  options: ["Dialogue and consensus", "Violence", "Social boycott", "Caste punishment"],
  answer: 0
},
{
  q: "Rural power structure is best studied through?",
  options: ["Caste, class and political institutions", "Technology only", "Urban models", "Corporate models"],
  answer: 0
},
/* =========================
   UNIT–4: RURAL DEVELOPMENT
   ========================= */

{
  q: "Rabindranath Tagore emphasized rural development through?",
  options: ["Urban planning", "Education and literacy", "Corporate growth", "Industrialization"],
  answer: 1
},
{
  q: "Tagore's approach to rural reconstruction included?",
  options: ["Cooperatives", "Vocational training", "Basic education", "All of the above"],
  answer: 3
},
{
  q: "Gandhian approach to rural development is known as?",
  options: ["Industrialization", "Gram Swaraj", "Urban planning", "Corporate control"],
  answer: 1
},
{
  q: "Gandhi promoted rural economy through?",
  options: ["Khadi and trusteeship", "Corporations", "Urban markets", "Technology"],
  answer: 0
},
{
  q: "Nai Talim refers to?",
  options: ["Basic education", "Urban schooling", "Industrial training", "Corporate skill development"],
  answer: 0
},

{
  q: "Bhoodan and Gramdan movement was initiated by?",
  options: ["Mahatma Gandhi", "Vinoba Bhave", "Rabindranath Tagore", "Jawaharlal Nehru"],
  answer: 1
},
{
  q: "Community Development Programme (CDP) started in?",
  options: ["1952", "1960", "1975", "1980"],
  answer: 0
},
{
  q: "Integrated Rural Development Programme (IRDP) aimed at?",
  options: ["Urban growth", "Poverty alleviation", "Industrialization", "Corporate profit"],
  answer: 1
},
{
  q: "Poverty Alleviation Programme (PAP) focuses on?",
  options: ["Rural poverty", "Urban poverty", "Corporate development", "Industrial growth"],
  answer: 0
},
{
  q: "Training of Rural Youth for Self-Employment is abbreviated as?",
  options: ["TRYSEM", "IRDP", "MGNREGS", "SGSY"],
  answer: 0
},

{
  q: "Jawahar Rozgar Yojana (JRY) focuses on?",
  options: ["Employment generation", "Urban housing", "Industrial expansion", "Corporate jobs"],
  answer: 0
},
{
  q: "Swarnajayanthi Gram Swarozgar Yojana (SGSY) aims at?",
  options: ["Rural self-employment", "Urban development", "Industrial projects", "Corporate support"],
  answer: 0
},
{
  q: "DWCRA scheme targets?",
  options: ["Women and children in rural areas", "Urban elite", "Industrial workers", "Corporate employees"],
  answer: 0
},
{
  q: "MGNREGS guarantees employment for?",
  options: ["50 days", "75 days", "100 days", "150 days"],
  answer: 2
},
{
  q: "Pradhan Mantri Awas Yojana (PMAY) focuses on?",
  options: ["Rural housing", "Urban luxury", "Corporate offices", "Industrial units"],
  answer: 0
},

{
  q: "Integrated Child Development Services Scheme (ICDS) benefits?",
  options: ["Rural children and mothers", "Urban children only", "Industrial workers", "Corporate employees"],
  answer: 0
},
{
  q: "National Rural Drinking Water Programme (NRDWP) ensures?",
  options: ["Safe drinking water in rural areas", "Urban water supply", "Industrial water supply", "Corporate water supply"],
  answer: 0
},
{
  q: "Rashtriya Swasthya Bima Yojana (RSBY) provides?",
  options: ["Health insurance for rural families", "Urban luxury healthcare", "Corporate health benefits", "Industrial insurance"],
  answer: 0
},
{
  q: "National Rural Health Mission (NRHM) aims at?",
  options: ["Improving rural health infrastructure", "Urban hospitals", "Corporate wellness", "Industrial healthcare"],
  answer: 0
},
{
  q: "Nirmal Bharat Abhiyan (NBA) focuses on?",
  options: ["Rural sanitation", "Urban sanitation", "Corporate hygiene", "Industrial waste management"],
  answer: 0
},

{
  q: "Kisan Call Centres (KCC) provide?",
  options: ["Agricultural information to farmers", "Urban advice", "Corporate consultancy", "Industrial guidance"],
  answer: 0
},
{
  q: "Pradhan Mantri Gram Sadak Yojana (PMGSY) ensures?",
  options: ["Rural road connectivity", "Urban road development", "Industrial road planning", "Corporate transport"],
  answer: 0
},
{
  q: "Special focus of rural development programmes is on?",
  options: ["Education, health, employment", "Industrial expansion", "Corporate profit", "Urban luxury"],
  answer: 0
},
{
  q: "Rural development schemes are mainly funded by?",
  options: ["Central and State Governments", "Urban corporations", "Private companies", "Industrial firms"],
  answer: 0
},
{
  q: "Cooperatives in rural development help in?",
  options: ["Credit and marketing", "Industrial expansion", "Urban trade", "Corporate profit"],
  answer: 0
},

{
  q: "Vocational training in rural areas helps?",
  options: ["Skill development", "Corporate jobs", "Urban migration", "Industrial monopoly"],
  answer: 0
},
{
  q: "Rural development programmes contribute to?",
  options: ["Poverty reduction", "Urbanization", "Industrial growth", "Corporate dominance"],
  answer: 0
},
{
  q: "Gandhian Gram Swaraj emphasizes?",
  options: ["Self-reliance and village governance", "Urban planning", "Corporate control", "Industrialization"],
  answer: 0
},
{
  q: "Bhoodan movement promoted?",
  options: ["Land donation for the landless", "Urban housing", "Industrial land", "Corporate property"],
  answer: 0
},
{
  q: "Gramdan means?",
  options: ["Village land donation collectively", "Urban land planning", "Industrial land reform", "Corporate property sharing"],
  answer: 0
},

{
  q: "Rural education programs focus on?",
  options: ["Literacy, skill, awareness", "Urban technology", "Industrial skills", "Corporate training"],
  answer: 0
},
{
  q: "Rural employment programmes aim to?",
  options: ["Generate work opportunities", "Urban jobs", "Industrial profit", "Corporate growth"],
  answer: 0
},
{
  q: "TRYSEM scheme provides?",
  options: ["Training for rural youth", "Urban education", "Industrial training", "Corporate skills"],
  answer: 0
},
{
  q: "CDP was first implemented in?",
  options: ["1952", "1960", "1975", "1980"],
  answer: 0
},
{
  q: "SGSY scheme replaced?",
  options: ["IRDP and other schemes", "JRY", "Urban projects", "Corporate initiatives"],
  answer: 0
},

{
  q: "DWCRA empowers?",
  options: ["Rural women for self-employment", "Urban elite", "Industrial workers", "Corporate employees"],
  answer: 0
},
{
  q: "PMAY aims to provide?",
  options: ["Affordable housing to rural poor", "Urban luxury apartments", "Industrial offices", "Corporate buildings"],
  answer: 0
},
{
  q: "ICDS benefits?",
  options: ["Children and mothers in rural areas", "Urban children", "Industrial employees", "Corporate workers"],
  answer: 0
},
{
  q: "NRDWP ensures?",
  options: ["Safe drinking water in villages", "Urban water supply", "Industrial water supply", "Corporate water supply"],
  answer: 0
},
{
  q: "RSBY provides?",
  options: ["Health insurance for poor rural families", "Urban luxury insurance", "Industrial health plans", "Corporate coverage"],
  answer: 0
},

{
  q: "NRHM focuses on?",
  options: ["Improving rural healthcare system", "Urban hospitals", "Corporate wellness", "Industrial health"],
  answer: 0
},
{
  q: "NBA scheme focuses on?",
  options: ["Sanitation in villages", "Urban sanitation", "Corporate hygiene", "Industrial waste management"],
  answer: 0
},
{
  q: "KCC provides information about?",
  options: ["Agriculture and farming", "Urban business", "Industrial technology", "Corporate trends"],
  answer: 0
},
{
  q: "PMGSY aims to provide?",
  options: ["All-weather roads to rural habitations", "Urban road networks", "Industrial roads", "Corporate transport"],
  answer: 0
},
{
  q: "Rural development programs are monitored by?",
  options: ["Government agencies", "Urban NGOs", "Corporate boards", "Industrial units"],
  answer: 0
},
{
  q: "Success of rural development schemes depends on?",
  options: ["Community participation", "Urban support", "Corporate funds", "Industrial assistance"],
  answer: 0
},
{
  q: "Vocational training helps rural youth to?",
  options: ["Start small businesses", "Work in urban IT", "Industrial employment", "Corporate jobs"],
  answer: 0
},
{
  q: "Cooperative societies help in?",
  options: ["Credit, marketing, and production", "Urban trade only", "Corporate profit", "Industrial monopoly"],
  answer: 0
},
{
  q: "Tagore's rural reconstruction was based on?",
  options: ["Education, culture, economy", "Industrialization", "Urban planning", "Corporate control"],
  answer: 0
},
{
  q: "Gandhian approach focuses on?",
  options: ["Self-sufficiency, rural governance", "Urbanization", "Industrial growth", "Corporate expansion"],
  answer: 0
},
{
  q: "Bhoodan movement was initiated to?",
  options: ["Redistribute land voluntarily", "Urban housing", "Industrial land", "Corporate assets"],
  answer: 0
},
{
  q: "Gramdan emphasizes?",
  options: ["Collective ownership of village land", "Urban real estate", "Industrial property", "Corporate holdings"],
  answer: 0
},
{
  q: "Rural health initiatives aim at?",
  options: ["Better health and hygiene", "Urban hospitals", "Corporate wellness", "Industrial health services"],
  answer: 0
},
{
  q: "Rural entrepreneurship refers to?",
  options: ["Urban business", "Industrial management", "Business initiatives in rural areas", "Corporate finance"],
  answer: 2
},
{
  q: "A key feature of rural entrepreneurship is?",
  options: ["Small scale and local focus", "Large corporate setup", "Industrial monopoly", "Urbanization"],
  answer: 0
},
{
  q: "Rural entrepreneurship contributes to?",
  options: ["Employment generation", "Urban migration", "Industrial monopoly", "Corporate profit"],
  answer: 0
},
{
  q: "Types of rural entrepreneurship include?",
  options: ["Agriculture-based, service-based, and micro enterprises", "Only industrial", "Only IT", "Only corporate"],
  answer: 0
},
{
  q: "Scope of rural entrepreneurship is?",
  options: ["Limited to villages", "National and international", "Urban only", "Corporate only"],
  answer: 1
},

{
  q: "Importance of rural entrepreneurship includes?",
  options: ["Employment, income generation, local development", "Urban luxury", "Industrial monopoly", "Corporate growth"],
  answer: 0
},
{
  q: "Self Help Groups (SHGs) promote entrepreneurship among?",
  options: ["Rural women", "Urban youth", "Corporate employees", "Industrial workers"],
  answer: 0
},
{
  q: "Micro-credit is used for?",
  options: ["Small loans to rural entrepreneurs", "Urban business", "Industrial finance", "Corporate lending"],
  answer: 0
},
{
  q: "NABARD provides financial support through?",
  options: ["Rural Infrastructure Development Fund (RIDF)", "Corporate loans", "Urban finance", "Industrial funds"],
  answer: 0
},
{
  q: "Skill Development Programmes (SDPs) aim to?",
  options: ["Enhance entrepreneurial skills", "Urban training", "Industrial technology", "Corporate management"],
  answer: 0
},

{
  q: "Start-Up India scheme supports?",
  options: ["Entrepreneurship in urban and rural areas", "Urban luxury projects", "Industrial monopoly", "Corporate startups only"],
  answer: 0
},
{
  q: "Pradhan Mantri Mudra Yojana (PMMY) provides?",
  options: ["Loans to small entrepreneurs", "Urban housing", "Industrial investment", "Corporate finance"],
  answer: 0
},
{
  q: "Anandadhara Scheme is a?",
  options: ["State government initiative in West Bengal for rural entrepreneurship", "Urban development program", "Industrial project", "Corporate funding scheme"],
  answer: 0
},
{
  q: "Rural entrepreneurship promotes?",
  options: ["Local economy and self-reliance", "Urban migration", "Industrial monopoly", "Corporate control"],
  answer: 0
},
{
  q: "Entrepreneurship development helps in?",
  options: ["Reducing unemployment", "Urbanization", "Industrial concentration", "Corporate monopoly"],
  answer: 0
},

{
  q: "Rural entrepreneurs often start with?",
  options: ["Small investments", "Corporate funding", "Urban capital", "Industrial monopoly"],
  answer: 0
},
{
  q: "Rural entrepreneurship encourages?",
  options: ["Local skill utilization", "Urban dependency", "Industrial monopoly", "Corporate hiring"],
  answer: 0
},
{
  q: "Micro-credit loans are usually given by?",
  options: ["Banks and SHGs", "Urban corporations", "Industrial firms", "Corporate banks only"],
  answer: 0
},
{
  q: "SHGs are mainly composed of?",
  options: ["Rural women", "Urban youth", "Corporate employees", "Industrial workers"],
  answer: 0
},
{
  q: "NABARD's RIDF helps in?",
  options: ["Developing rural infrastructure", "Urban projects", "Industrial setup", "Corporate offices"],
  answer: 0
},

{
  q: "Skill Development Programmes aim to?",
  options: ["Enhance technical and managerial skills", "Urban luxury skills", "Industrial monopoly skills", "Corporate training only"],
  answer: 0
},
{
  q: "Start-Up India encourages?",
  options: ["Innovation and entrepreneurship in rural areas", "Urban malls", "Industrial monopoly", "Corporate expansion"],
  answer: 0
},
{
  q: "PMMY loan is for?",
  options: ["Micro and small entrepreneurs", "Urban builders", "Industrialists", "Corporate startups only"],
  answer: 0
},
{
  q: "Anandadhara Scheme provides?",
  options: ["Training and financial support to rural youth", "Urban luxury", "Industrial capital", "Corporate benefits"],
  answer: 0
},
{
  q: "Rural entrepreneurship strengthens?",
  options: ["Rural economy", "Urban markets", "Industrial monopoly", "Corporate growth"],
  answer: 0
},

{
  q: "Rural entrepreneurship reduces?",
  options: ["Unemployment", "Urban wealth", "Industrial monopoly", "Corporate profit"],
  answer: 0
},
{
  q: "Rural women entrepreneurship is promoted through?",
  options: ["SHGs and Micro-credit", "Corporate training", "Urban luxury", "Industrial monopoly"],
  answer: 0
},
{
  q: "Financial institutions play a role in?",
  options: ["Supporting rural entrepreneurship", "Urban development", "Corporate monopoly", "Industrial growth"],
  answer: 0
},
{
  q: "Entrepreneurship development programs include?",
  options: ["Training, credit, skill development", "Urban malls", "Industrial factories", "Corporate offices"],
  answer: 0
},
{
  q: "Rural entrepreneurship leads to?",
  options: ["Local employment and economic growth", "Urban migration", "Industrial monopoly", "Corporate concentration"],
  answer: 0
},

{
  q: "Rural entrepreneurs face challenges like?",
  options: ["Credit constraints, lack of skills", "Urban luxury", "Industrial competition", "Corporate regulations"],
  answer: 0
},
{
  q: "Micro-credit helps in?",
  options: ["Overcoming financial constraints", "Urban finance", "Corporate funding", "Industrial monopoly"],
  answer: 0
},
{
  q: "Training programs improve?",
  options: ["Entrepreneurial knowledge and skills", "Urban luxury skills", "Corporate skills", "Industrial monopoly"],
  answer: 0
},
{
  q: "Government initiatives aim to?",
  options: ["Promote rural entrepreneurship", "Urban development only", "Industrial monopoly", "Corporate profit"],
  answer: 0
},
{
  q: "Rural entrepreneurship is important for?",
  options: ["Balanced regional development", "Urban growth", "Industrial expansion", "Corporate wealth"],
  answer: 0
},

{
  q: "Entrepreneurship in rural areas supports?",
  options: ["Self-employment", "Urban dependency", "Industrial monopoly", "Corporate hiring"],
  answer: 0
},
{
  q: "SHGs improve?",
  options: ["Financial and social empowerment of rural women", "Urban influence", "Industrial monopoly", "Corporate profit"],
  answer: 0
},
{
  q: "Micro-credit loans are usually of?",
  options: ["Small amounts", "Large capital", "Industrial scale", "Corporate funding"],
  answer: 0
},
{
  q: "Rural entrepreneurship encourages?",
  options: ["Innovation and local resource utilization", "Urban migration", "Industrial monopoly", "Corporate growth"],
  answer: 0
},
{
  q: "NABARD supports rural entrepreneurship through?",
  options: ["RIDF and SDPs", "Urban funds", "Industrial monopoly", "Corporate finance"],
  answer: 0
},

{
  q: "Start-Up India and PMMY help in?",
  options: ["Providing financial and policy support", "Urban luxury", "Industrial monopoly", "Corporate profit"],
  answer: 0
},
{
  q: "State initiatives like Anandadhara aim to?",
  options: ["Promote rural youth entrepreneurship", "Urban markets", "Industrial growth", "Corporate control"],
  answer: 0
},
{
  q: "Rural entrepreneurship improves?",
  options: ["Income and standard of living", "Urban lifestyle", "Industrial monopoly", "Corporate wealth"],
  answer: 0
},
{
  q: "Skill development is crucial for?",
  options: ["Effective entrepreneurship", "Urban luxury", "Industrial monopoly", "Corporate management"],
  answer: 0
},
{
  q: "Rural entrepreneurship contributes to?",
  options: ["Economic self-reliance", "Urban dependency", "Industrial monopoly", "Corporate dominance"],
  answer: 0
},

{
  q: "SHGs act as?",
  options: ["Support groups for credit and training", "Urban social clubs", "Corporate boards", "Industrial unions"],
  answer: 0
},
{
  q: "Micro-credit and skill development reduce?",
  options: ["Rural poverty and unemployment", "Urban luxury", "Industrial monopoly", "Corporate profit"],
  answer: 0
},
{
  q: "Rural entrepreneurship ultimately aims at?",
  options: ["Empowering rural population economically", "Urban migration", "Industrial monopoly", "Corporate profit"],
  answer: 0
},
{
  q: "Government schemes support?",
  options: ["Rural businesses, training and financial aid", "Urban luxury", "Industrial monopoly", "Corporate profit"],
  answer: 0
},
{
  q: "Entrepreneurship development programs improve?",
  options: ["Skills, knowledge, and economic participation", "Urban lifestyle", "Industrial monopoly", "Corporate control"],
  answer: 0
}

];

let currentQ = 0;
let score = 0;
const userAnswers = new Array(questions.length);

const quizContainer = document.getElementById('quiz-container');
const prevBtn = document.getElementById('prevBtn');
const nextBtn = document.getElementById('nextBtn');
const scoreDiv = document.getElementById('score');

function showQuestion(index){
    const q = questions[index];
    let html = `<div class="question">${index+1}. ${q.q}</div><ul class="options">`;
    q.options.forEach((opt, i)=>{
        html += `<li onclick="selectOption(this, ${i})">${opt}</li>`;
    });
    html += `</ul>`;
    quizContainer.innerHTML = html;
    highlightPrevious();
}

function selectOption(li, index){
    const q = questions[currentQ];
    const optionsLis = document.querySelectorAll('.options li');
    optionsLis.forEach(el => el.classList.remove('correct','wrong'));

    if(index === q.answer){
        li.classList.add('correct');
        if(userAnswers[currentQ]!==true){
            score++;
            userAnswers[currentQ] = true;
        }
    } else {
        li.classList.add('wrong');
        userAnswers[currentQ] = false;
        optionsLis[q.answer].classList.add('correct');
    }
}

function highlightPrevious(){
    const userAns = userAnswers[currentQ];
    if(userAns === true){
        document.querySelectorAll('.options li')[questions[currentQ].answer].classList.add('correct');
    } else if(userAns === false){
        document.querySelectorAll('.options li')[questions[currentQ].answer].classList.add('correct');
    }
}

prevBtn.onclick = ()=>{
    if(currentQ>0){
        currentQ--;
        showQuestion(currentQ);
    }
}

nextBtn.onclick = ()=>{
    if(currentQ < questions.length-1){
        currentQ++;
        showQuestion(currentQ);
    } else {
        quizContainer.style.display = 'none';
        prevBtn.style.display = 'none';
        nextBtn.style.display = 'none';
        scoreDiv.style.display = 'block';
        scoreDiv.innerHTML = `Your Score: ${score} / ${questions.length}`;
    }
}

showQuestion(currentQ);